package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceTypeHypervisor {
  def unwrap: software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor
}
object InstanceTypeHypervisor {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor
  ): zio.aws.ec2.model.InstanceTypeHypervisor = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.NITRO =>
      val r = nitro
      r
    case software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.XEN =>
      val r = xen
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceTypeHypervisor {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor =
      software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.UNKNOWN_TO_SDK_VERSION
  }
  case object nitro extends zio.aws.ec2.model.InstanceTypeHypervisor {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor =
      software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.NITRO
  }
  case object xen extends zio.aws.ec2.model.InstanceTypeHypervisor {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor =
      software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor.XEN
  }
}
