package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceEventWindowStateChange(
    instanceEventWindowId: Option[InstanceEventWindowId] = None,
    state: Option[zio.aws.ec2.model.InstanceEventWindowState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange = {
    import InstanceEventWindowStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
      .builder()
      .optionallyWith(
        instanceEventWindowId.map(value =>
          InstanceEventWindowId.unwrap(value): java.lang.String
        )
      )(_.instanceEventWindowId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly =
    zio.aws.ec2.model.InstanceEventWindowStateChange.wrap(buildAwsValue())
}
object InstanceEventWindowStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceEventWindowStateChange =
      zio.aws.ec2.model.InstanceEventWindowStateChange(
        instanceEventWindowId.map(value => value),
        state.map(value => value)
      )
    def instanceEventWindowId: Option[InstanceEventWindowId]
    def state: Option[zio.aws.ec2.model.InstanceEventWindowState]
    def getInstanceEventWindowId: ZIO[Any, AwsError, InstanceEventWindowId] =
      AwsError.unwrapOptionField("instanceEventWindowId", instanceEventWindowId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceEventWindowState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ) extends zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly {
    override val instanceEventWindowId: Option[InstanceEventWindowId] = scala
      .Option(impl.instanceEventWindowId())
      .map(value => zio.aws.ec2.model.primitives.InstanceEventWindowId(value))
    override val state: Option[zio.aws.ec2.model.InstanceEventWindowState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.ec2.model.InstanceEventWindowState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceEventWindowStateChange
  ): zio.aws.ec2.model.InstanceEventWindowStateChange.ReadOnly = new Wrapper(
    impl
  )
}
