package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportInstanceRequest(
    description: Option[String] = None,
    diskImages: Option[Iterable[zio.aws.ec2.model.DiskImage]] = None,
    launchSpecification: Option[
      zio.aws.ec2.model.ImportInstanceLaunchSpecification
    ] = None,
    platform: zio.aws.ec2.model.PlatformValues
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportInstanceRequest = {
    import ImportInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportInstanceRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        diskImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.diskImages)
      .optionallyWith(launchSpecification.map(value => value.buildAwsValue()))(
        _.launchSpecification
      )
      .platform(platform.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportInstanceRequest.ReadOnly =
    zio.aws.ec2.model.ImportInstanceRequest.wrap(buildAwsValue())
}
object ImportInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportInstanceRequest =
      zio.aws.ec2.model.ImportInstanceRequest(
        description.map(value => value),
        diskImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        launchSpecification.map(value => value.asEditable),
        platform
      )
    def description: Option[String]
    def diskImages: Option[List[zio.aws.ec2.model.DiskImage.ReadOnly]]
    def launchSpecification
        : Option[zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly]
    def platform: zio.aws.ec2.model.PlatformValues
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskImages
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.DiskImage.ReadOnly]] =
      AwsError.unwrapOptionField("diskImages", diskImages)
    def getLaunchSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("launchSpecification", launchSpecification)
    def getPlatform: ZIO[Any, Nothing, zio.aws.ec2.model.PlatformValues] =
      ZIO.succeed(platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceRequest
  ) extends zio.aws.ec2.model.ImportInstanceRequest.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val diskImages
        : Option[List[zio.aws.ec2.model.DiskImage.ReadOnly]] = scala
      .Option(impl.diskImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DiskImage.wrap(item)
        }.toList
      )
    override val launchSpecification
        : Option[zio.aws.ec2.model.ImportInstanceLaunchSpecification.ReadOnly] =
      scala
        .Option(impl.launchSpecification())
        .map(value =>
          zio.aws.ec2.model.ImportInstanceLaunchSpecification.wrap(value)
        )
    override val platform: zio.aws.ec2.model.PlatformValues =
      zio.aws.ec2.model.PlatformValues.wrap(impl.platform())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportInstanceRequest
  ): zio.aws.ec2.model.ImportInstanceRequest.ReadOnly = new Wrapper(impl)
}
