package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HostProperties(
    cores: Option[Integer] = None,
    instanceType: Option[String] = None,
    instanceFamily: Option[String] = None,
    sockets: Option[Integer] = None,
    totalVCpus: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostProperties = {
    import HostProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostProperties
      .builder()
      .optionallyWith(
        cores.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.cores)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(
        sockets.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.sockets)
      .optionallyWith(
        totalVCpus.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.totalVCpus)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostProperties.ReadOnly =
    zio.aws.ec2.model.HostProperties.wrap(buildAwsValue())
}
object HostProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HostProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostProperties =
      zio.aws.ec2.model.HostProperties(
        cores.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value),
        sockets.map(value => value),
        totalVCpus.map(value => value)
      )
    def cores: Option[Integer]
    def instanceType: Option[String]
    def instanceFamily: Option[String]
    def sockets: Option[Integer]
    def totalVCpus: Option[Integer]
    def getCores: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cores", cores)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getSockets: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sockets", sockets)
    def getTotalVCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalVCpus", totalVCpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostProperties
  ) extends zio.aws.ec2.model.HostProperties.ReadOnly {
    override val cores: Option[Integer] = scala
      .Option(impl.cores())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val instanceFamily: Option[String] =
      scala.Option(impl.instanceFamily()).map(value => value: String)
    override val sockets: Option[Integer] = scala
      .Option(impl.sockets())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val totalVCpus: Option[Integer] = scala
      .Option(impl.totalVCpus())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostProperties
  ): zio.aws.ec2.model.HostProperties.ReadOnly = new Wrapper(impl)
}
