package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  GetGroupsForCapacityReservationRequestMaxResults,
  CapacityReservationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetGroupsForCapacityReservationRequest(
    capacityReservationId: CapacityReservationId,
    nextToken: Option[String] = None,
    maxResults: Option[GetGroupsForCapacityReservationRequestMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest = {
    import GetGroupsForCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          GetGroupsForCapacityReservationRequestMaxResults.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetGroupsForCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
      .wrap(buildAwsValue())
}
object GetGroupsForCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest =
      zio.aws.ec2.model.GetGroupsForCapacityReservationRequest(
        capacityReservationId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def capacityReservationId: CapacityReservationId
    def nextToken: Option[String]
    def maxResults: Option[GetGroupsForCapacityReservationRequestMaxResults]
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, GetGroupsForCapacityReservationRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest
  ) extends zio.aws.ec2.model.GetGroupsForCapacityReservationRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults
        : Option[GetGroupsForCapacityReservationRequestMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .GetGroupsForCapacityReservationRequestMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetGroupsForCapacityReservationRequest
  ): zio.aws.ec2.model.GetGroupsForCapacityReservationRequest.ReadOnly =
    new Wrapper(impl)
}
