package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait FleetReplacementStrategy {
  def unwrap: software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy
}
object FleetReplacementStrategy {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy
  ): zio.aws.ec2.model.FleetReplacementStrategy = value match {
    case software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.LAUNCH =>
      val r = launch
      r
    case software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.LAUNCH_BEFORE_TERMINATE =>
      val r = `launch-before-terminate`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.FleetReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object launch extends zio.aws.ec2.model.FleetReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.LAUNCH
  }
  case object `launch-before-terminate`
      extends zio.aws.ec2.model.FleetReplacementStrategy {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy =
      software.amazon.awssdk.services.ec2.model.FleetReplacementStrategy.LAUNCH_BEFORE_TERMINATE
  }
}
