package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DnsNameState {
  def unwrap: software.amazon.awssdk.services.ec2.model.DnsNameState
}
object DnsNameState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DnsNameState
  ): zio.aws.ec2.model.DnsNameState = value match {
    case software.amazon.awssdk.services.ec2.model.DnsNameState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DnsNameState.PENDING_VERIFICATION =>
      val r = pendingVerification
      r
    case software.amazon.awssdk.services.ec2.model.DnsNameState.VERIFIED =>
      val r = verified
      r
    case software.amazon.awssdk.services.ec2.model.DnsNameState.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DnsNameState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsNameState =
      software.amazon.awssdk.services.ec2.model.DnsNameState.UNKNOWN_TO_SDK_VERSION
  }
  case object pendingVerification extends zio.aws.ec2.model.DnsNameState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsNameState =
      software.amazon.awssdk.services.ec2.model.DnsNameState.PENDING_VERIFICATION
  }
  case object verified extends zio.aws.ec2.model.DnsNameState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsNameState =
      software.amazon.awssdk.services.ec2.model.DnsNameState.VERIFIED
  }
  case object failed extends zio.aws.ec2.model.DnsNameState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsNameState =
      software.amazon.awssdk.services.ec2.model.DnsNameState.FAILED
  }
}
