package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableFastSnapshotRestoresResponse(
    successful: Option[
      Iterable[zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem]
    ] = None,
    unsuccessful: Option[
      Iterable[zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse = {
    import DisableFastSnapshotRestoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        unsuccessful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessful)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly =
    zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.wrap(buildAwsValue())
}
object DisableFastSnapshotRestoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastSnapshotRestoresResponse =
      zio.aws.ec2.model.DisableFastSnapshotRestoresResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessful.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem.ReadOnly]
    ]
    def unsuccessful: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly]
    ]
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
    def getUnsuccessful: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("unsuccessful", unsuccessful)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse
  ) extends zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly {
    override val successful: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem.ReadOnly]
    ] = scala
      .Option(impl.successful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DisableFastSnapshotRestoreSuccessItem.wrap(item)
        }.toList
      )
    override val unsuccessful: Option[
      List[zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.ReadOnly]
    ] = scala
      .Option(impl.unsuccessful())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DisableFastSnapshotRestoreErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastSnapshotRestoresResponse
  ): zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly =
    new Wrapper(impl)
}
