package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{DescribeSubnetsMaxResults, SubnetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSubnetsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    subnetIds: Option[Iterable[SubnetId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeSubnetsMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest = {
    import DescribeSubnetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeSubnetsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSubnetsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSubnetsRequest.wrap(buildAwsValue())
}
object DescribeSubnetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSubnetsRequest =
      zio.aws.ec2.model.DescribeSubnetsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        subnetIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def subnetIds: Option[List[SubnetId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeSubnetsMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeSubnetsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest
  ) extends zio.aws.ec2.model.DescribeSubnetsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val subnetIds: Option[List[SubnetId]] = scala
      .Option(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeSubnetsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeSubnetsMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest
  ): zio.aws.ec2.model.DescribeSubnetsRequest.ReadOnly = new Wrapper(impl)
}
