package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceTypesResponse(
    instanceTypes: Option[Iterable[zio.aws.ec2.model.InstanceTypeInfo]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse = {
    import DescribeInstanceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse
      .builder()
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceTypesResponse.wrap(buildAwsValue())
}
object DescribeInstanceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceTypesResponse =
      zio.aws.ec2.model.DescribeInstanceTypesResponse(
        instanceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceTypes: Option[List[zio.aws.ec2.model.InstanceTypeInfo.ReadOnly]]
    def nextToken: Option[NextToken]
    def getInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceTypeInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse
  ) extends zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly {
    override val instanceTypes
        : Option[List[zio.aws.ec2.model.InstanceTypeInfo.ReadOnly]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceTypeInfo.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse
  ): zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly = new Wrapper(
    impl
  )
}
