package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LocalGatewayRoutetableId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLocalGatewayRouteRequest(
    destinationCidrBlock: String,
    localGatewayRouteTableId: LocalGatewayRoutetableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest = {
    import DeleteLocalGatewayRouteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
      .builder()
      .destinationCidrBlock(destinationCidrBlock: java.lang.String)
      .localGatewayRouteTableId(
        LocalGatewayRoutetableId.unwrap(
          localGatewayRouteTableId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly =
    zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.wrap(buildAwsValue())
}
object DeleteLocalGatewayRouteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest =
      zio.aws.ec2.model.DeleteLocalGatewayRouteRequest(
        destinationCidrBlock,
        localGatewayRouteTableId
      )
    def destinationCidrBlock: String
    def localGatewayRouteTableId: LocalGatewayRoutetableId
    def getDestinationCidrBlock: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationCidrBlock)
    def getLocalGatewayRouteTableId
        : ZIO[Any, Nothing, LocalGatewayRoutetableId] =
      ZIO.succeed(localGatewayRouteTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ) extends zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly {
    override val destinationCidrBlock: String =
      impl.destinationCidrBlock(): String
    override val localGatewayRouteTableId: LocalGatewayRoutetableId =
      zio.aws.ec2.model.primitives
        .LocalGatewayRoutetableId(impl.localGatewayRouteTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLocalGatewayRouteRequest
  ): zio.aws.ec2.model.DeleteLocalGatewayRouteRequest.ReadOnly = new Wrapper(
    impl
  )
}
