package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IpamId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIpamRequest(ipamId: IpamId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamRequest = {
    import DeleteIpamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
      .builder()
      .ipamId(IpamId.unwrap(ipamId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamRequest.ReadOnly =
    zio.aws.ec2.model.DeleteIpamRequest.wrap(buildAwsValue())
}
object DeleteIpamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamRequest =
      zio.aws.ec2.model.DeleteIpamRequest(ipamId)
    def ipamId: IpamId
    def getIpamId: ZIO[Any, Nothing, IpamId] = ZIO.succeed(ipamId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ) extends zio.aws.ec2.model.DeleteIpamRequest.ReadOnly {
    override val ipamId: IpamId =
      zio.aws.ec2.model.primitives.IpamId(impl.ipamId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamRequest
  ): zio.aws.ec2.model.DeleteIpamRequest.ReadOnly = new Wrapper(impl)
}
