package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointServiceConfigurationRequest(
    acceptanceRequired: Option[Boolean] = None,
    privateDnsName: Option[String] = None,
    networkLoadBalancerArns: Option[Iterable[String]] = None,
    gatewayLoadBalancerArns: Option[Iterable[String]] = None,
    clientToken: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest = {
    import CreateVpcEndpointServiceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
      .builder()
      .optionallyWith(
        acceptanceRequired.map(value => value: java.lang.Boolean)
      )(_.acceptanceRequired)
      .optionallyWith(privateDnsName.map(value => value: java.lang.String))(
        _.privateDnsName
      )
      .optionallyWith(
        networkLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.networkLoadBalancerArns)
      .optionallyWith(
        gatewayLoadBalancerArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.gatewayLoadBalancerArns)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateVpcEndpointServiceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest =
      zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest(
        acceptanceRequired.map(value => value),
        privateDnsName.map(value => value),
        networkLoadBalancerArns.map(value => value),
        gatewayLoadBalancerArns.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceptanceRequired: Option[Boolean]
    def privateDnsName: Option[String]
    def networkLoadBalancerArns: Option[List[String]]
    def gatewayLoadBalancerArns: Option[List[String]]
    def clientToken: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getAcceptanceRequired: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("acceptanceRequired", acceptanceRequired)
    def getPrivateDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDnsName", privateDnsName)
    def getNetworkLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("networkLoadBalancerArns", networkLoadBalancerArns)
    def getGatewayLoadBalancerArns: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("gatewayLoadBalancerArns", gatewayLoadBalancerArns)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ) extends zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly {
    override val acceptanceRequired: Option[Boolean] =
      scala.Option(impl.acceptanceRequired()).map(value => value: Boolean)
    override val privateDnsName: Option[String] =
      scala.Option(impl.privateDnsName()).map(value => value: String)
    override val networkLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.networkLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val gatewayLoadBalancerArns: Option[List[String]] = scala
      .Option(impl.gatewayLoadBalancerArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ): zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
