package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointResponse(
    vpcEndpoint: Option[zio.aws.ec2.model.VpcEndpoint] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse = {
    import CreateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
      .builder()
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointResponse.wrap(buildAwsValue())
}
object CreateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcEndpointResponse =
      zio.aws.ec2.model.CreateVpcEndpointResponse(
        vpcEndpoint.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def vpcEndpoint: Option[zio.aws.ec2.model.VpcEndpoint.ReadOnly]
    def clientToken: Option[String]
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ) extends zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: Option[zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
      scala
        .Option(impl.vpcEndpoint())
        .map(value => zio.aws.ec2.model.VpcEndpoint.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ): zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly = new Wrapper(impl)
}
