package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFpgaImageRequest(
    inputStorageLocation: zio.aws.ec2.model.StorageLocation,
    logsStorageLocation: Option[zio.aws.ec2.model.StorageLocation] = None,
    description: Option[String] = None,
    name: Option[String] = None,
    clientToken: Option[String] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest = {
    import CreateFpgaImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
      .builder()
      .inputStorageLocation(inputStorageLocation.buildAwsValue())
      .optionallyWith(logsStorageLocation.map(value => value.buildAwsValue()))(
        _.logsStorageLocation
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly =
    zio.aws.ec2.model.CreateFpgaImageRequest.wrap(buildAwsValue())
}
object CreateFpgaImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFpgaImageRequest =
      zio.aws.ec2.model.CreateFpgaImageRequest(
        inputStorageLocation.asEditable,
        logsStorageLocation.map(value => value.asEditable),
        description.map(value => value),
        name.map(value => value),
        clientToken.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputStorageLocation: zio.aws.ec2.model.StorageLocation.ReadOnly
    def logsStorageLocation: Option[zio.aws.ec2.model.StorageLocation.ReadOnly]
    def description: Option[String]
    def name: Option[String]
    def clientToken: Option[String]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getInputStorageLocation
        : ZIO[Any, Nothing, zio.aws.ec2.model.StorageLocation.ReadOnly] =
      ZIO.succeed(inputStorageLocation)
    def getLogsStorageLocation
        : ZIO[Any, AwsError, zio.aws.ec2.model.StorageLocation.ReadOnly] =
      AwsError.unwrapOptionField("logsStorageLocation", logsStorageLocation)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ) extends zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly {
    override val inputStorageLocation
        : zio.aws.ec2.model.StorageLocation.ReadOnly =
      zio.aws.ec2.model.StorageLocation.wrap(impl.inputStorageLocation())
    override val logsStorageLocation
        : Option[zio.aws.ec2.model.StorageLocation.ReadOnly] = scala
      .Option(impl.logsStorageLocation())
      .map(value => zio.aws.ec2.model.StorageLocation.wrap(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest
  ): zio.aws.ec2.model.CreateFpgaImageRequest.ReadOnly = new Wrapper(impl)
}
