package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{OutpostArn, DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationRequest(
    clientToken: Option[String] = None,
    instanceType: String,
    instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform,
    availabilityZone: Option[String] = None,
    availabilityZoneId: Option[String] = None,
    tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy] = None,
    instanceCount: Integer,
    ebsOptimized: Option[Boolean] = None,
    ephemeralStorage: Option[Boolean] = None,
    endDate: Option[DateTime] = None,
    endDateType: Option[zio.aws.ec2.model.EndDateType] = None,
    instanceMatchCriteria: Option[zio.aws.ec2.model.InstanceMatchCriteria] =
      None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    outpostArn: Option[OutpostArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest = {
    import CreateCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .instanceType(instanceType: java.lang.String)
      .instancePlatform(instancePlatform.unwrap)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .instanceCount(Integer.unwrap(instanceCount): java.lang.Integer)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(ephemeralStorage.map(value => value: java.lang.Boolean))(
        _.ephemeralStorage
      )
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        outpostArn.map(value => OutpostArn.unwrap(value): java.lang.String)
      )(_.outpostArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationRequest.wrap(buildAwsValue())
}
object CreateCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationRequest =
      zio.aws.ec2.model.CreateCapacityReservationRequest(
        clientToken.map(value => value),
        instanceType,
        instancePlatform,
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        tenancy.map(value => value),
        instanceCount,
        ebsOptimized.map(value => value),
        ephemeralStorage.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        instanceMatchCriteria.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outpostArn.map(value => value)
      )
    def clientToken: Option[String]
    def instanceType: String
    def instancePlatform: zio.aws.ec2.model.CapacityReservationInstancePlatform
    def availabilityZone: Option[String]
    def availabilityZoneId: Option[String]
    def tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy]
    def instanceCount: Integer
    def ebsOptimized: Option[Boolean]
    def ephemeralStorage: Option[Boolean]
    def endDate: Option[DateTime]
    def endDateType: Option[zio.aws.ec2.model.EndDateType]
    def instanceMatchCriteria: Option[zio.aws.ec2.model.InstanceMatchCriteria]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def outpostArn: Option[OutpostArn]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceType: ZIO[Any, Nothing, String] = ZIO.succeed(instanceType)
    def getInstancePlatform: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.CapacityReservationInstancePlatform
    ] = ZIO.succeed(instancePlatform)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getTenancy
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationTenancy] =
      AwsError.unwrapOptionField("tenancy", tenancy)
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEphemeralStorage: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getOutpostArn: ZIO[Any, AwsError, OutpostArn] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ) extends zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val instanceType: String = impl.instanceType(): String
    override val instancePlatform
        : zio.aws.ec2.model.CapacityReservationInstancePlatform =
      zio.aws.ec2.model.CapacityReservationInstancePlatform
        .wrap(impl.instancePlatform())
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val availabilityZoneId: Option[String] =
      scala.Option(impl.availabilityZoneId()).map(value => value: String)
    override val tenancy: Option[zio.aws.ec2.model.CapacityReservationTenancy] =
      scala
        .Option(impl.tenancy())
        .map(value => zio.aws.ec2.model.CapacityReservationTenancy.wrap(value))
    override val instanceCount: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.instanceCount())
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val ephemeralStorage: Option[Boolean] =
      scala.Option(impl.ephemeralStorage()).map(value => value: Boolean)
    override val endDate: Option[DateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Option[zio.aws.ec2.model.EndDateType] = scala
      .Option(impl.endDateType())
      .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val instanceMatchCriteria
        : Option[zio.aws.ec2.model.InstanceMatchCriteria] = scala
      .Option(impl.instanceMatchCriteria())
      .map(value => zio.aws.ec2.model.InstanceMatchCriteria.wrap(value))
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val outpostArn: Option[OutpostArn] = scala
      .Option(impl.outpostArn())
      .map(value => zio.aws.ec2.model.primitives.OutpostArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationRequest
  ): zio.aws.ec2.model.CreateCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
