package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AllocationState {
  def unwrap: software.amazon.awssdk.services.ec2.model.AllocationState
}
object AllocationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AllocationState
  ): zio.aws.ec2.model.AllocationState = value match {
    case software.amazon.awssdk.services.ec2.model.AllocationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.UNDER_ASSESSMENT =>
      val r = `under-assessment`
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.PERMANENT_FAILURE =>
      val r = `permanent-failure`
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.RELEASED =>
      val r = released
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.RELEASED_PERMANENT_FAILURE =>
      val r = `released-permanent-failure`
      r
    case software.amazon.awssdk.services.ec2.model.AllocationState.PENDING =>
      val r = pending
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.AVAILABLE
  }
  case object `under-assessment` extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.UNDER_ASSESSMENT
  }
  case object `permanent-failure` extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.PERMANENT_FAILURE
  }
  case object released extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.RELEASED
  }
  case object `released-permanent-failure`
      extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.RELEASED_PERMANENT_FAILURE
  }
  case object pending extends zio.aws.ec2.model.AllocationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AllocationState =
      software.amazon.awssdk.services.ec2.model.AllocationState.PENDING
  }
}
