package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpnConnectionDeviceType(
    vpnConnectionDeviceTypeId: Option[String] = None,
    vendor: Option[String] = None,
    platform: Option[String] = None,
    software: Option[String] = None
) {
  def buildAwsValue()
      : _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType = {
    import VpnConnectionDeviceType.zioAwsBuilderHelper.BuilderOps
    _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
      .builder()
      .optionallyWith(
        vpnConnectionDeviceTypeId.map(value => value: java.lang.String)
      )(_.vpnConnectionDeviceTypeId)
      .optionallyWith(vendor.map(value => value: java.lang.String))(_.vendor)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(software.map(value => value: java.lang.String))(
        _.software
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly =
    zio.aws.ec2.model.VpnConnectionDeviceType.wrap(buildAwsValue())
}
object VpnConnectionDeviceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnectionDeviceType =
      zio.aws.ec2.model.VpnConnectionDeviceType(
        vpnConnectionDeviceTypeId.map(value => value),
        vendor.map(value => value),
        platform.map(value => value),
        software.map(value => value)
      )
    def vpnConnectionDeviceTypeId: Option[String]
    def vendor: Option[String]
    def platform: Option[String]
    def software: Option[String]
    def getVpnConnectionDeviceTypeId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpnConnectionDeviceTypeId", vpnConnectionDeviceTypeId)
    def getVendor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getSoftware: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("software", software)
  }
  private final class Wrapper(
      impl: _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ) extends zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly {
    override val vpnConnectionDeviceTypeId: Option[String] =
      scala.Option(impl.vpnConnectionDeviceTypeId()).map(value => value: String)
    override val vendor: Option[String] =
      scala.Option(impl.vendor()).map(value => value: String)
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val software: Option[String] =
      scala.Option(impl.software()).map(value => value: String)
  }
  def wrap(
      impl: _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ): zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly = new Wrapper(impl)
}
