package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDomainOptions(
    igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue] = None,
    staticSourcesSupport: Option[zio.aws.ec2.model.StaticSourcesSupportValue] =
      None,
    autoAcceptSharedAssociations: Option[
      zio.aws.ec2.model.AutoAcceptSharedAssociationsValue
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainOptions = {
    import TransitGatewayMulticastDomainOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainOptions
      .builder()
      .optionallyWith(igmpv2Support.map(value => value.unwrap))(_.igmpv2Support)
      .optionallyWith(staticSourcesSupport.map(value => value.unwrap))(
        _.staticSourcesSupport
      )
      .optionallyWith(autoAcceptSharedAssociations.map(value => value.unwrap))(
        _.autoAcceptSharedAssociations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.wrap(buildAwsValue())
}
object TransitGatewayMulticastDomainOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastDomainOptions =
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions(
        igmpv2Support.map(value => value),
        staticSourcesSupport.map(value => value),
        autoAcceptSharedAssociations.map(value => value)
      )
    def igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue]
    def staticSourcesSupport
        : Option[zio.aws.ec2.model.StaticSourcesSupportValue]
    def autoAcceptSharedAssociations
        : Option[zio.aws.ec2.model.AutoAcceptSharedAssociationsValue]
    def getIgmpv2Support
        : ZIO[Any, AwsError, zio.aws.ec2.model.Igmpv2SupportValue] =
      AwsError.unwrapOptionField("igmpv2Support", igmpv2Support)
    def getStaticSourcesSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.StaticSourcesSupportValue] =
      AwsError.unwrapOptionField("staticSourcesSupport", staticSourcesSupport)
    def getAutoAcceptSharedAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAssociationsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAssociations",
      autoAcceptSharedAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainOptions
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly {
    override val igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue] =
      scala
        .Option(impl.igmpv2Support())
        .map(value => zio.aws.ec2.model.Igmpv2SupportValue.wrap(value))
    override val staticSourcesSupport
        : Option[zio.aws.ec2.model.StaticSourcesSupportValue] = scala
      .Option(impl.staticSourcesSupport())
      .map(value => zio.aws.ec2.model.StaticSourcesSupportValue.wrap(value))
    override val autoAcceptSharedAssociations
        : Option[zio.aws.ec2.model.AutoAcceptSharedAssociationsValue] = scala
      .Option(impl.autoAcceptSharedAssociations())
      .map(value =>
        zio.aws.ec2.model.AutoAcceptSharedAssociationsValue.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainOptions
  ): zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly =
    new Wrapper(impl)
}
