package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficMirrorFilterRule(
    trafficMirrorFilterRuleId: Option[String] = None,
    trafficMirrorFilterId: Option[String] = None,
    trafficDirection: Option[zio.aws.ec2.model.TrafficDirection] = None,
    ruleNumber: Option[Integer] = None,
    ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction] = None,
    protocol: Option[Integer] = None,
    destinationPortRange: Option[zio.aws.ec2.model.TrafficMirrorPortRange] =
      None,
    sourcePortRange: Option[zio.aws.ec2.model.TrafficMirrorPortRange] = None,
    destinationCidrBlock: Option[String] = None,
    sourceCidrBlock: Option[String] = None,
    description: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule = {
    import TrafficMirrorFilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
      .builder()
      .optionallyWith(
        trafficMirrorFilterRuleId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterRuleId)
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(trafficDirection.map(value => value.unwrap))(
        _.trafficDirection
      )
      .optionallyWith(
        ruleNumber.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.ruleNumber)
      .optionallyWith(ruleAction.map(value => value.unwrap))(_.ruleAction)
      .optionallyWith(
        protocol.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.protocol)
      .optionallyWith(destinationPortRange.map(value => value.buildAwsValue()))(
        _.destinationPortRange
      )
      .optionallyWith(sourcePortRange.map(value => value.buildAwsValue()))(
        _.sourcePortRange
      )
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(sourceCidrBlock.map(value => value: java.lang.String))(
        _.sourceCidrBlock
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(buildAwsValue())
}
object TrafficMirrorFilterRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorFilterRule =
      zio.aws.ec2.model.TrafficMirrorFilterRule(
        trafficMirrorFilterRuleId.map(value => value),
        trafficMirrorFilterId.map(value => value),
        trafficDirection.map(value => value),
        ruleNumber.map(value => value),
        ruleAction.map(value => value),
        protocol.map(value => value),
        destinationPortRange.map(value => value.asEditable),
        sourcePortRange.map(value => value.asEditable),
        destinationCidrBlock.map(value => value),
        sourceCidrBlock.map(value => value),
        description.map(value => value)
      )
    def trafficMirrorFilterRuleId: Option[String]
    def trafficMirrorFilterId: Option[String]
    def trafficDirection: Option[zio.aws.ec2.model.TrafficDirection]
    def ruleNumber: Option[Integer]
    def ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction]
    def protocol: Option[Integer]
    def destinationPortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly]
    def sourcePortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly]
    def destinationCidrBlock: Option[String]
    def sourceCidrBlock: Option[String]
    def description: Option[String]
    def getTrafficMirrorFilterRuleId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorFilterRuleId", trafficMirrorFilterRuleId)
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getTrafficDirection
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficDirection] =
      AwsError.unwrapOptionField("trafficDirection", trafficDirection)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
    def getRuleAction
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorRuleAction] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getProtocol: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly
    ] = AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getSourcePortRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly
    ] = AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getSourceCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCidrBlock", sourceCidrBlock)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ) extends zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly {
    override val trafficMirrorFilterRuleId: Option[String] =
      scala.Option(impl.trafficMirrorFilterRuleId()).map(value => value: String)
    override val trafficMirrorFilterId: Option[String] =
      scala.Option(impl.trafficMirrorFilterId()).map(value => value: String)
    override val trafficDirection: Option[zio.aws.ec2.model.TrafficDirection] =
      scala
        .Option(impl.trafficDirection())
        .map(value => zio.aws.ec2.model.TrafficDirection.wrap(value))
    override val ruleNumber: Option[Integer] = scala
      .Option(impl.ruleNumber())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ruleAction: Option[zio.aws.ec2.model.TrafficMirrorRuleAction] =
      scala
        .Option(impl.ruleAction())
        .map(value => zio.aws.ec2.model.TrafficMirrorRuleAction.wrap(value))
    override val protocol: Option[Integer] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val destinationPortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly] = scala
      .Option(impl.destinationPortRange())
      .map(value => zio.aws.ec2.model.TrafficMirrorPortRange.wrap(value))
    override val sourcePortRange
        : Option[zio.aws.ec2.model.TrafficMirrorPortRange.ReadOnly] = scala
      .Option(impl.sourcePortRange())
      .map(value => zio.aws.ec2.model.TrafficMirrorPortRange.wrap(value))
    override val destinationCidrBlock: Option[String] =
      scala.Option(impl.destinationCidrBlock()).map(value => value: String)
    override val sourceCidrBlock: Option[String] =
      scala.Option(impl.sourceCidrBlock()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule
  ): zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly = new Wrapper(impl)
}
