package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TerminateConnectionStatus(
    connectionId: Option[String] = None,
    previousStatus: Option[zio.aws.ec2.model.ClientVpnConnectionStatus] = None,
    currentStatus: Option[zio.aws.ec2.model.ClientVpnConnectionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus = {
    import TerminateConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
      .builder()
      .optionallyWith(connectionId.map(value => value: java.lang.String))(
        _.connectionId
      )
      .optionallyWith(previousStatus.map(value => value.buildAwsValue()))(
        _.previousStatus
      )
      .optionallyWith(currentStatus.map(value => value.buildAwsValue()))(
        _.currentStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly =
    zio.aws.ec2.model.TerminateConnectionStatus.wrap(buildAwsValue())
}
object TerminateConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TerminateConnectionStatus =
      zio.aws.ec2.model.TerminateConnectionStatus(
        connectionId.map(value => value),
        previousStatus.map(value => value.asEditable),
        currentStatus.map(value => value.asEditable)
      )
    def connectionId: Option[String]
    def previousStatus
        : Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def currentStatus
        : Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly]
    def getConnectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("connectionId", connectionId)
    def getPreviousStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("previousStatus", previousStatus)
    def getCurrentStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("currentStatus", currentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ) extends zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly {
    override val connectionId: Option[String] =
      scala.Option(impl.connectionId()).map(value => value: String)
    override val previousStatus
        : Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] = scala
      .Option(impl.previousStatus())
      .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
    override val currentStatus
        : Option[zio.aws.ec2.model.ClientVpnConnectionStatus.ReadOnly] = scala
      .Option(impl.currentStatus())
      .map(value => zio.aws.ec2.model.ClientVpnConnectionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TerminateConnectionStatus
  ): zio.aws.ec2.model.TerminateConnectionStatus.ReadOnly = new Wrapper(impl)
}
