package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotFleetMonitoring(enabled: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring = {
    import SpotFleetMonitoring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly =
    zio.aws.ec2.model.SpotFleetMonitoring.wrap(buildAwsValue())
}
object SpotFleetMonitoring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotFleetMonitoring =
      zio.aws.ec2.model.SpotFleetMonitoring(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring
  ) extends zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring
  ): zio.aws.ec2.model.SpotFleetMonitoring.ReadOnly = new Wrapper(impl)
}
