package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesPrivateIpAddressConfig(
    primary: Option[Boolean] = None,
    privateIpAddress: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig = {
    import ScheduledInstancesPrivateIpAddressConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig
      .builder()
      .optionallyWith(primary.map(value => value: java.lang.Boolean))(_.primary)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig
      .wrap(buildAwsValue())
}
object ScheduledInstancesPrivateIpAddressConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig =
      zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig(
        primary.map(value => value),
        privateIpAddress.map(value => value)
      )
    def primary: Option[Boolean]
    def privateIpAddress: Option[String]
    def getPrimary: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("primary", primary)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig
  ) extends zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly {
    override val primary: Option[Boolean] =
      scala.Option(impl.primary()).map(value => value: Boolean)
    override val privateIpAddress: Option[String] =
      scala.Option(impl.privateIpAddress()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig
  ): zio.aws.ec2.model.ScheduledInstancesPrivateIpAddressConfig.ReadOnly =
    new Wrapper(impl)
}
