package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  KeyPairName,
  SecurityGroupId,
  KernelId,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesLaunchSpecification(
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping]
    ] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile
    ] = None,
    imageId: ImageId,
    instanceType: Option[String] = None,
    kernelId: Option[KernelId] = None,
    keyName: Option[KeyPairName] = None,
    monitoring: Option[zio.aws.ec2.model.ScheduledInstancesMonitoring] = None,
    networkInterfaces: Option[
      Iterable[zio.aws.ec2.model.ScheduledInstancesNetworkInterface]
    ] = None,
    placement: Option[zio.aws.ec2.model.ScheduledInstancesPlacement] = None,
    ramdiskId: Option[RamdiskId] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    subnetId: Option[SubnetId] = None,
    userData: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification = {
    import ScheduledInstancesLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesLaunchSpecification
      .wrap(buildAwsValue())
}
object ScheduledInstancesLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesLaunchSpecification =
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId,
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value)
      )
    def blockDeviceMappings: Option[
      List[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly]
    ]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile: Option[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ]
    def imageId: ImageId
    def instanceType: Option[String]
    def kernelId: Option[KernelId]
    def keyName: Option[KeyPairName]
    def monitoring
        : Option[zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly]
    def networkInterfaces: Option[
      List[zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly]
    ]
    def placement
        : Option[zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly]
    def ramdiskId: Option[RamdiskId]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def subnetId: Option[SubnetId]
    def userData: Option[String]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ) extends zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly {
    override val blockDeviceMappings: Option[
      List[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile: Option[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ] = scala
      .Option(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.wrap(value)
      )
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val kernelId: Option[KernelId] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Option[zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.ScheduledInstancesMonitoring.wrap(value)
        )
    override val networkInterfaces: Option[
      List[zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly]
    ] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesNetworkInterface.wrap(item)
        }.toList
      )
    override val placement
        : Option[zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.ScheduledInstancesPlacement.wrap(value))
    override val ramdiskId: Option[RamdiskId] = scala
      .Option(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val subnetId: Option[SubnetId] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ): zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
    new Wrapper(impl)
}
