package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourceStatement(
    resources: Option[Iterable[String]] = None,
    resourceTypes: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResourceStatement = {
    import ResourceStatement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResourceStatement
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResourceStatement.ReadOnly =
    zio.aws.ec2.model.ResourceStatement.wrap(buildAwsValue())
}
object ResourceStatement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResourceStatement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResourceStatement =
      zio.aws.ec2.model.ResourceStatement(
        resources.map(value => value),
        resourceTypes.map(value => value)
      )
    def resources: Option[List[String]]
    def resourceTypes: Option[List[String]]
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getResourceTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResourceStatement
  ) extends zio.aws.ec2.model.ResourceStatement.ReadOnly {
    override val resources: Option[List[String]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resourceTypes: Option[List[String]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResourceStatement
  ): zio.aws.ec2.model.ResourceStatement.ReadOnly = new Wrapper(impl)
}
