package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RejectTransitGatewayMulticastDomainAssociationsResponse(
    associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse = {
    import RejectTransitGatewayMulticastDomainAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse
      .builder()
      .optionallyWith(associations.map(value => value.buildAwsValue()))(
        _.associations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse
      .wrap(buildAwsValue())
}
object RejectTransitGatewayMulticastDomainAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse =
      zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse(
        associations.map(value => value.asEditable)
      )
    def associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ]
    def getAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = AwsError.unwrapOptionField("associations", associations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse
  ) extends zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly {
    override val associations: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.ReadOnly
    ] = scala
      .Option(impl.associations())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse
  ): zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
