package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Phase2DHGroupNumbersRequestListValue(
    value: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue = {
    import Phase2DHGroupNumbersRequestListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue
      .builder()
      .optionallyWith(
        value.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly =
    zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.wrap(buildAwsValue())
}
object Phase2DHGroupNumbersRequestListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue =
      zio.aws.ec2.model
        .Phase2DHGroupNumbersRequestListValue(value.map(value => value))
    def value: Option[Integer]
    def getValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue
  ) extends zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly {
    override val value: Option[Integer] = scala
      .Option(impl.value())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Phase2DHGroupNumbersRequestListValue
  ): zio.aws.ec2.model.Phase2DHGroupNumbersRequestListValue.ReadOnly =
    new Wrapper(impl)
}
