package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInsightsAccessScopeAnalysisId,
  MillisecondDateTime,
  Integer,
  ResourceArn,
  NetworkInsightsAccessScopeId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAccessScopeAnalysis(
    networkInsightsAccessScopeAnalysisId: Option[
      NetworkInsightsAccessScopeAnalysisId
    ] = None,
    networkInsightsAccessScopeAnalysisArn: Option[ResourceArn] = None,
    networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId] = None,
    status: Option[zio.aws.ec2.model.AnalysisStatus] = None,
    statusMessage: Option[String] = None,
    warningMessage: Option[String] = None,
    startDate: Option[MillisecondDateTime] = None,
    endDate: Option[MillisecondDateTime] = None,
    findingsFound: Option[zio.aws.ec2.model.FindingsFound] = None,
    analyzedEniCount: Option[Integer] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis = {
    import NetworkInsightsAccessScopeAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisId.map(value =>
          NetworkInsightsAccessScopeAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisId)
      .optionallyWith(
        networkInsightsAccessScopeAnalysisArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisArn)
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(findingsFound.map(value => value.unwrap))(_.findingsFound)
      .optionallyWith(
        analyzedEniCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.analyzedEniCount)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.wrap(buildAwsValue())
}
object NetworkInsightsAccessScopeAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis =
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis(
        networkInsightsAccessScopeAnalysisId.map(value => value),
        networkInsightsAccessScopeAnalysisArn.map(value => value),
        networkInsightsAccessScopeId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        warningMessage.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        findingsFound.map(value => value),
        analyzedEniCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeAnalysisId
        : Option[NetworkInsightsAccessScopeAnalysisId]
    def networkInsightsAccessScopeAnalysisArn: Option[ResourceArn]
    def networkInsightsAccessScopeId: Option[NetworkInsightsAccessScopeId]
    def status: Option[zio.aws.ec2.model.AnalysisStatus]
    def statusMessage: Option[String]
    def warningMessage: Option[String]
    def startDate: Option[MillisecondDateTime]
    def endDate: Option[MillisecondDateTime]
    def findingsFound: Option[zio.aws.ec2.model.FindingsFound]
    def analyzedEniCount: Option[Integer]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeAnalysisId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisId",
        networkInsightsAccessScopeAnalysisId
      )
    def getNetworkInsightsAccessScopeAnalysisArn
        : ZIO[Any, AwsError, ResourceArn] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopeAnalysisArn",
      networkInsightsAccessScopeAnalysisArn
    )
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFindingsFound: ZIO[Any, AwsError, zio.aws.ec2.model.FindingsFound] =
      AwsError.unwrapOptionField("findingsFound", findingsFound)
    def getAnalyzedEniCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("analyzedEniCount", analyzedEniCount)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ) extends zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : Option[NetworkInsightsAccessScopeAnalysisId] = scala
      .Option(impl.networkInsightsAccessScopeAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(value)
      )
    override val networkInsightsAccessScopeAnalysisArn: Option[ResourceArn] =
      scala
        .Option(impl.networkInsightsAccessScopeAnalysisArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val networkInsightsAccessScopeId
        : Option[NetworkInsightsAccessScopeId] = scala
      .Option(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val status: Option[zio.aws.ec2.model.AnalysisStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.AnalysisStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val warningMessage: Option[String] =
      scala.Option(impl.warningMessage()).map(value => value: String)
    override val startDate: Option[MillisecondDateTime] = scala
      .Option(impl.startDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Option[MillisecondDateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val findingsFound: Option[zio.aws.ec2.model.FindingsFound] = scala
      .Option(impl.findingsFound())
      .map(value => zio.aws.ec2.model.FindingsFound.wrap(value))
    override val analyzedEniCount: Option[Integer] = scala
      .Option(impl.analyzedEniCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ): zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly =
    new Wrapper(impl)
}
