package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkAcl(
    associations: Option[Iterable[zio.aws.ec2.model.NetworkAclAssociation]] =
      None,
    entries: Option[Iterable[zio.aws.ec2.model.NetworkAclEntry]] = None,
    isDefault: Option[Boolean] = None,
    networkAclId: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None,
    vpcId: Option[String] = None,
    ownerId: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NetworkAcl = {
    import NetworkAcl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkAcl
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(networkAclId.map(value => value: java.lang.String))(
        _.networkAclId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkAcl.ReadOnly =
    zio.aws.ec2.model.NetworkAcl.wrap(buildAwsValue())
}
object NetworkAcl {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NetworkAcl] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkAcl = zio.aws.ec2.model.NetworkAcl(
      associations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      entries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isDefault.map(value => value),
      networkAclId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcId.map(value => value),
      ownerId.map(value => value)
    )
    def associations
        : Option[List[zio.aws.ec2.model.NetworkAclAssociation.ReadOnly]]
    def entries: Option[List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]]
    def isDefault: Option[Boolean]
    def networkAclId: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Option[String]
    def ownerId: Option[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkAclAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]] =
      AwsError.unwrapOptionField("entries", entries)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getNetworkAclId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAcl
  ) extends zio.aws.ec2.model.NetworkAcl.ReadOnly {
    override val associations
        : Option[List[zio.aws.ec2.model.NetworkAclAssociation.ReadOnly]] = scala
      .Option(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkAclAssociation.wrap(item)
        }.toList
      )
    override val entries
        : Option[List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]] = scala
      .Option(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.NetworkAclEntry.wrap(item)
        }.toList
      )
    override val isDefault: Option[Boolean] =
      scala.Option(impl.isDefault()).map(value => value: Boolean)
    override val networkAclId: Option[String] =
      scala.Option(impl.networkAclId()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAcl
  ): zio.aws.ec2.model.NetworkAcl.ReadOnly = new Wrapper(impl)
}
