package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpcEndpointServicePermissionsRequest(
    serviceId: VpcEndpointServiceId,
    addAllowedPrincipals: Option[Iterable[String]] = None,
    removeAllowedPrincipals: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest = {
    import ModifyVpcEndpointServicePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .optionallyWith(
        addAllowedPrincipals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addAllowedPrincipals)
      .optionallyWith(
        removeAllowedPrincipals.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeAllowedPrincipals)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest
      .wrap(buildAwsValue())
}
object ModifyVpcEndpointServicePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest =
      zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest(
        serviceId,
        addAllowedPrincipals.map(value => value),
        removeAllowedPrincipals.map(value => value)
      )
    def serviceId: VpcEndpointServiceId
    def addAllowedPrincipals: Option[List[String]]
    def removeAllowedPrincipals: Option[List[String]]
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
    def getAddAllowedPrincipals: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("addAllowedPrincipals", addAllowedPrincipals)
    def getRemoveAllowedPrincipals: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("removeAllowedPrincipals", removeAllowedPrincipals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ) extends zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
    override val addAllowedPrincipals: Option[List[String]] = scala
      .Option(impl.addAllowedPrincipals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val removeAllowedPrincipals: Option[List[String]] = scala
      .Option(impl.removeAllowedPrincipals())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ): zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
