package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkInterfaceId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyNetworkInterfaceAttributeRequest(
    attachment: Option[zio.aws.ec2.model.NetworkInterfaceAttachmentChanges] =
      None,
    description: Option[zio.aws.ec2.model.AttributeValue] = None,
    groups: Option[Iterable[SecurityGroupId]] = None,
    networkInterfaceId: NetworkInterfaceId,
    sourceDestCheck: Option[zio.aws.ec2.model.AttributeBooleanValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest = {
    import ModifyNetworkInterfaceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(description.map(value => value.buildAwsValue()))(
        _.description
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest
      .wrap(buildAwsValue())
}
object ModifyNetworkInterfaceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest =
      zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest(
        attachment.map(value => value.asEditable),
        description.map(value => value.asEditable),
        groups.map(value => value),
        networkInterfaceId,
        sourceDestCheck.map(value => value.asEditable)
      )
    def attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly]
    def description: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def groups: Option[List[SecurityGroupId]]
    def networkInterfaceId: NetworkInterfaceId
    def sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("description", description)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ) extends zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly {
    override val attachment
        : Option[zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.ReadOnly] =
      scala
        .Option(impl.attachment())
        .map(value =>
          zio.aws.ec2.model.NetworkInterfaceAttachmentChanges.wrap(value)
        )
    override val description
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.description())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val groups: Option[List[SecurityGroupId]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
    override val sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.sourceDestCheck())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ): zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest.ReadOnly =
    new Wrapper(impl)
}
