package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LicenseConfiguration(
    licenseConfigurationArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LicenseConfiguration = {
    import LicenseConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LicenseConfiguration
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LicenseConfiguration.ReadOnly =
    zio.aws.ec2.model.LicenseConfiguration.wrap(buildAwsValue())
}
object LicenseConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LicenseConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LicenseConfiguration = zio.aws.ec2.model
      .LicenseConfiguration(licenseConfigurationArn.map(value => value))
    def licenseConfigurationArn: Option[String]
    def getLicenseConfigurationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("licenseConfigurationArn", licenseConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LicenseConfiguration
  ) extends zio.aws.ec2.model.LicenseConfiguration.ReadOnly {
    override val licenseConfigurationArn: Option[String] =
      scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LicenseConfiguration
  ): zio.aws.ec2.model.LicenseConfiguration.ReadOnly = new Wrapper(impl)
}
