package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateCapacityReservationSpecificationRequest(
    capacityReservationPreference: Option[
      zio.aws.ec2.model.CapacityReservationPreference
    ] = None,
    capacityReservationTarget: Option[
      zio.aws.ec2.model.CapacityReservationTarget
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest = {
    import LaunchTemplateCapacityReservationSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
      .builder()
      .optionallyWith(capacityReservationPreference.map(value => value.unwrap))(
        _.capacityReservationPreference
      )
      .optionallyWith(
        capacityReservationTarget.map(value => value.buildAwsValue())
      )(_.capacityReservationTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateCapacityReservationSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest =
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest(
        capacityReservationPreference.map(value => value),
        capacityReservationTarget.map(value => value.asEditable)
      )
    def capacityReservationPreference
        : Option[zio.aws.ec2.model.CapacityReservationPreference]
    def capacityReservationTarget
        : Option[zio.aws.ec2.model.CapacityReservationTarget.ReadOnly]
    def getCapacityReservationPreference
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationPreference] =
      AwsError.unwrapOptionField(
        "capacityReservationPreference",
        capacityReservationPreference
      )
    def getCapacityReservationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationTarget.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationTarget",
      capacityReservationTarget
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
  ) extends zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly {
    override val capacityReservationPreference
        : Option[zio.aws.ec2.model.CapacityReservationPreference] = scala
      .Option(impl.capacityReservationPreference())
      .map(value => zio.aws.ec2.model.CapacityReservationPreference.wrap(value))
    override val capacityReservationTarget
        : Option[zio.aws.ec2.model.CapacityReservationTarget.ReadOnly] = scala
      .Option(impl.capacityReservationTarget())
      .map(value => zio.aws.ec2.model.CapacityReservationTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
  ): zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
