package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InstanceNetworkInterfaceAttachment(
    attachTime: Option[DateTime] = None,
    attachmentId: Option[String] = None,
    deleteOnTermination: Option[Boolean] = None,
    deviceIndex: Option[Integer] = None,
    status: Option[zio.aws.ec2.model.AttachmentStatus] = None,
    networkCardIndex: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment = {
    import InstanceNetworkInterfaceAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
      .builder()
      .optionallyWith(attachTime.map(value => DateTime.unwrap(value): Instant))(
        _.attachTime
      )
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        deviceIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.deviceIndex)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        networkCardIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.networkCardIndex)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly =
    zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.wrap(buildAwsValue())
}
object InstanceNetworkInterfaceAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceNetworkInterfaceAttachment =
      zio.aws.ec2.model.InstanceNetworkInterfaceAttachment(
        attachTime.map(value => value),
        attachmentId.map(value => value),
        deleteOnTermination.map(value => value),
        deviceIndex.map(value => value),
        status.map(value => value),
        networkCardIndex.map(value => value)
      )
    def attachTime: Option[DateTime]
    def attachmentId: Option[String]
    def deleteOnTermination: Option[Boolean]
    def deviceIndex: Option[Integer]
    def status: Option[zio.aws.ec2.model.AttachmentStatus]
    def networkCardIndex: Option[Integer]
    def getAttachTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ) extends zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly {
    override val attachTime: Option[DateTime] = scala
      .Option(impl.attachTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val attachmentId: Option[String] =
      scala.Option(impl.attachmentId()).map(value => value: String)
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val deviceIndex: Option[Integer] = scala
      .Option(impl.deviceIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val status: Option[zio.aws.ec2.model.AttachmentStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val networkCardIndex: Option[Integer] = scala
      .Option(impl.networkCardIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment
  ): zio.aws.ec2.model.InstanceNetworkInterfaceAttachment.ReadOnly =
    new Wrapper(impl)
}
