package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class IamInstanceProfileAssociation(
    associationId: Option[String] = None,
    instanceId: Option[String] = None,
    iamInstanceProfile: Option[zio.aws.ec2.model.IamInstanceProfile] = None,
    state: Option[zio.aws.ec2.model.IamInstanceProfileAssociationState] = None,
    timestamp: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation = {
    import IamInstanceProfileAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(timestamp.map(value => DateTime.unwrap(value): Instant))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly =
    zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(buildAwsValue())
}
object IamInstanceProfileAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IamInstanceProfileAssociation =
      zio.aws.ec2.model.IamInstanceProfileAssociation(
        associationId.map(value => value),
        instanceId.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        state.map(value => value),
        timestamp.map(value => value)
      )
    def associationId: Option[String]
    def instanceId: Option[String]
    def iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfile.ReadOnly]
    def state: Option[zio.aws.ec2.model.IamInstanceProfileAssociationState]
    def timestamp: Option[DateTime]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getIamInstanceProfile
        : ZIO[Any, AwsError, zio.aws.ec2.model.IamInstanceProfile.ReadOnly] =
      AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileAssociationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ) extends zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly {
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val iamInstanceProfile
        : Option[zio.aws.ec2.model.IamInstanceProfile.ReadOnly] = scala
      .Option(impl.iamInstanceProfile())
      .map(value => zio.aws.ec2.model.IamInstanceProfile.wrap(value))
    override val state
        : Option[zio.aws.ec2.model.IamInstanceProfileAssociationState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.IamInstanceProfileAssociationState.wrap(value)
      )
    override val timestamp: Option[DateTime] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IamInstanceProfileAssociation
  ): zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly = new Wrapper(
    impl
  )
}
