package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  NextToken,
  PrefixListMaxResults,
  PrefixListResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListEntriesRequest(
    prefixListId: PrefixListResourceId,
    targetVersion: Option[Long] = None,
    maxResults: Option[PrefixListMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest = {
    import GetManagedPrefixListEntriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
      .builder()
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(targetVersion.map(value => value: java.lang.Long))(
        _.targetVersion
      )
      .optionallyWith(
        maxResults.map(value => PrefixListMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.wrap(buildAwsValue())
}
object GetManagedPrefixListEntriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest =
      zio.aws.ec2.model.GetManagedPrefixListEntriesRequest(
        prefixListId,
        targetVersion.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def prefixListId: PrefixListResourceId
    def targetVersion: Option[Long]
    def maxResults: Option[PrefixListMaxResults]
    def nextToken: Option[NextToken]
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getTargetVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getMaxResults: ZIO[Any, AwsError, PrefixListMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ) extends zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly {
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val targetVersion: Option[Long] =
      scala.Option(impl.targetVersion()).map(value => value: Long)
    override val maxResults: Option[PrefixListMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.PrefixListMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListEntriesRequest
  ): zio.aws.ec2.model.GetManagedPrefixListEntriesRequest.ReadOnly =
    new Wrapper(impl)
}
