package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  GetCapacityReservationUsageRequestMaxResults,
  CapacityReservationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetCapacityReservationUsageRequest(
    capacityReservationId: CapacityReservationId,
    nextToken: Option[String] = None,
    maxResults: Option[GetCapacityReservationUsageRequestMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest = {
    import GetCapacityReservationUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          GetCapacityReservationUsageRequestMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetCapacityReservationUsageRequest.ReadOnly =
    zio.aws.ec2.model.GetCapacityReservationUsageRequest.wrap(buildAwsValue())
}
object GetCapacityReservationUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetCapacityReservationUsageRequest =
      zio.aws.ec2.model.GetCapacityReservationUsageRequest(
        capacityReservationId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def capacityReservationId: CapacityReservationId
    def nextToken: Option[String]
    def maxResults: Option[GetCapacityReservationUsageRequestMaxResults]
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, GetCapacityReservationUsageRequestMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest
  ) extends zio.aws.ec2.model.GetCapacityReservationUsageRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults
        : Option[GetCapacityReservationUsageRequestMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .GetCapacityReservationUsageRequestMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetCapacityReservationUsageRequest
  ): zio.aws.ec2.model.GetCapacityReservationUsageRequest.ReadOnly =
    new Wrapper(impl)
}
