package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableImageDeprecationResponse(
    returnValue: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse = {
    import EnableImageDeprecationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly =
    zio.aws.ec2.model.EnableImageDeprecationResponse.wrap(buildAwsValue())
}
object EnableImageDeprecationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableImageDeprecationResponse =
      zio.aws.ec2.model
        .EnableImageDeprecationResponse(returnValue.map(value => value))
    def returnValue: Option[Boolean]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse
  ) extends zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableImageDeprecationResponse
  ): zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly = new Wrapper(
    impl
  )
}
