package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DiskImage(
    description: Option[String] = None,
    image: Option[zio.aws.ec2.model.DiskImageDetail] = None,
    volume: Option[zio.aws.ec2.model.VolumeDetail] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.DiskImage = {
    import DiskImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskImage
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(image.map(value => value.buildAwsValue()))(_.image)
      .optionallyWith(volume.map(value => value.buildAwsValue()))(_.volume)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskImage.ReadOnly =
    zio.aws.ec2.model.DiskImage.wrap(buildAwsValue())
}
object DiskImage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.DiskImage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskImage = zio.aws.ec2.model.DiskImage(
      description.map(value => value),
      image.map(value => value.asEditable),
      volume.map(value => value.asEditable)
    )
    def description: Option[String]
    def image: Option[zio.aws.ec2.model.DiskImageDetail.ReadOnly]
    def volume: Option[zio.aws.ec2.model.VolumeDetail.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImage
        : ZIO[Any, AwsError, zio.aws.ec2.model.DiskImageDetail.ReadOnly] =
      AwsError.unwrapOptionField("image", image)
    def getVolume: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeDetail.ReadOnly] =
      AwsError.unwrapOptionField("volume", volume)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskImage
  ) extends zio.aws.ec2.model.DiskImage.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val image: Option[zio.aws.ec2.model.DiskImageDetail.ReadOnly] =
      scala
        .Option(impl.image())
        .map(value => zio.aws.ec2.model.DiskImageDetail.wrap(value))
    override val volume: Option[zio.aws.ec2.model.VolumeDetail.ReadOnly] = scala
      .Option(impl.volume())
      .map(value => zio.aws.ec2.model.VolumeDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskImage
  ): zio.aws.ec2.model.DiskImage.ReadOnly = new Wrapper(impl)
}
