package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcEndpointServiceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServiceConfigurationsRequest(
    serviceIds: Option[Iterable[VpcEndpointServiceId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest = {
    import DescribeVpcEndpointServiceConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
      .builder()
      .optionallyWith(
        serviceIds.map(value =>
          value.map { item =>
            VpcEndpointServiceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serviceIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServiceConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest =
      zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest(
        serviceIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def serviceIds: Option[List[VpcEndpointServiceId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getServiceIds: ZIO[Any, AwsError, List[VpcEndpointServiceId]] =
      AwsError.unwrapOptionField("serviceIds", serviceIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest.ReadOnly {
    override val serviceIds: Option[List[VpcEndpointServiceId]] = scala
      .Option(impl.serviceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VpcEndpointServiceId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ): zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
