package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcClassicLinkResponse(
    vpcs: Option[Iterable[zio.aws.ec2.model.VpcClassicLink]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse = {
    import DescribeVpcClassicLinkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse
      .builder()
      .optionallyWith(
        vpcs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcClassicLinkResponse.wrap(buildAwsValue())
}
object DescribeVpcClassicLinkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcClassicLinkResponse =
      zio.aws.ec2.model.DescribeVpcClassicLinkResponse(
        vpcs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpcs: Option[List[zio.aws.ec2.model.VpcClassicLink.ReadOnly]]
    def getVpcs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpcClassicLink.ReadOnly]] =
      AwsError.unwrapOptionField("vpcs", vpcs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse
  ) extends zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly {
    override val vpcs: Option[List[zio.aws.ec2.model.VpcClassicLink.ReadOnly]] =
      scala
        .Option(impl.vpcs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcClassicLink.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcClassicLinkResponse
  ): zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly = new Wrapper(
    impl
  )
}
