package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SecurityGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecurityGroupReferencesRequest(
    groupId: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest = {
    import DescribeSecurityGroupReferencesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest
      .builder()
      .groupId(groupId.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest
      .wrap(buildAwsValue())
}
object DescribeSecurityGroupReferencesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest =
      zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest(groupId)
    def groupId: List[SecurityGroupId]
    def getGroupId: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest
  ) extends zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest.ReadOnly {
    override val groupId: List[SecurityGroupId] = impl
      .groupId()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupReferencesRequest
  ): zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest.ReadOnly =
    new Wrapper(impl)
}
