package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{NextToken, DITOMaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceTypeOfferingsRequest(
    locationType: Option[zio.aws.ec2.model.LocationType] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[DITOMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest = {
    import DescribeInstanceTypeOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest
      .builder()
      .optionallyWith(locationType.map(value => value.unwrap))(_.locationType)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => DITOMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest.wrap(buildAwsValue())
}
object DescribeInstanceTypeOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest =
      zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest(
        locationType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def locationType: Option[zio.aws.ec2.model.LocationType]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[DITOMaxResults]
    def nextToken: Option[NextToken]
    def getLocationType: ZIO[Any, AwsError, zio.aws.ec2.model.LocationType] =
      AwsError.unwrapOptionField("locationType", locationType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, DITOMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest
  ) extends zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest.ReadOnly {
    override val locationType: Option[zio.aws.ec2.model.LocationType] = scala
      .Option(impl.locationType())
      .map(value => zio.aws.ec2.model.LocationType.wrap(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[DITOMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.DITOMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceTypeOfferingsRequest
  ): zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
