package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFlowLogsResponse(
    flowLogs: Option[Iterable[zio.aws.ec2.model.FlowLog]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse = {
    import DescribeFlowLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse
      .builder()
      .optionallyWith(
        flowLogs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.flowLogs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFlowLogsResponse.wrap(buildAwsValue())
}
object DescribeFlowLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFlowLogsResponse =
      zio.aws.ec2.model.DescribeFlowLogsResponse(
        flowLogs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def flowLogs: Option[List[zio.aws.ec2.model.FlowLog.ReadOnly]]
    def nextToken: Option[String]
    def getFlowLogs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.FlowLog.ReadOnly]] =
      AwsError.unwrapOptionField("flowLogs", flowLogs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse
  ) extends zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly {
    override val flowLogs: Option[List[zio.aws.ec2.model.FlowLog.ReadOnly]] =
      scala
        .Option(impl.flowLogs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FlowLog.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsResponse
  ): zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly = new Wrapper(impl)
}
