package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAvailabilityZonesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    zoneNames: Option[Iterable[String]] = None,
    zoneIds: Option[Iterable[String]] = None,
    allAvailabilityZones: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest = {
    import DescribeAvailabilityZonesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        zoneNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.zoneNames)
      .optionallyWith(
        zoneIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.zoneIds)
      .optionallyWith(
        allAvailabilityZones.map(value => value: java.lang.Boolean)
      )(_.allAvailabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAvailabilityZonesRequest.wrap(buildAwsValue())
}
object DescribeAvailabilityZonesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAvailabilityZonesRequest =
      zio.aws.ec2.model.DescribeAvailabilityZonesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zoneNames.map(value => value),
        zoneIds.map(value => value),
        allAvailabilityZones.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def zoneNames: Option[List[String]]
    def zoneIds: Option[List[String]]
    def allAvailabilityZones: Option[Boolean]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getZoneNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("zoneNames", zoneNames)
    def getZoneIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("zoneIds", zoneIds)
    def getAllAvailabilityZones: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allAvailabilityZones", allAvailabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ) extends zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val zoneNames: Option[List[String]] = scala
      .Option(impl.zoneNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val zoneIds: Option[List[String]] = scala
      .Option(impl.zoneIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allAvailabilityZones: Option[Boolean] =
      scala.Option(impl.allAvailabilityZones()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesRequest
  ): zio.aws.ec2.model.DescribeAvailabilityZonesRequest.ReadOnly = new Wrapper(
    impl
  )
}
