package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAccountAttributesRequest(
    attributeNames: Option[Iterable[zio.aws.ec2.model.AccountAttributeName]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest = {
    import DescribeAccountAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
      .builder()
      .optionallyWith(
        attributeNames.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.attributeNamesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeAccountAttributesRequest.wrap(buildAwsValue())
}
object DescribeAccountAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeAccountAttributesRequest =
      zio.aws.ec2.model
        .DescribeAccountAttributesRequest(attributeNames.map(value => value))
    def attributeNames: Option[List[zio.aws.ec2.model.AccountAttributeName]]
    def getAttributeNames
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AccountAttributeName]] =
      AwsError.unwrapOptionField("attributeNames", attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ) extends zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly {
    override val attributeNames
        : Option[List[zio.aws.ec2.model.AccountAttributeName]] = scala
      .Option(impl.attributeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccountAttributeName.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeAccountAttributesRequest
  ): zio.aws.ec2.model.DescribeAccountAttributesRequest.ReadOnly = new Wrapper(
    impl
  )
}
