package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayMulticastGroupSourcesResponse(
    deregisteredMulticastGroupSources: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse = {
    import DeregisterTransitGatewayMulticastGroupSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse
      .builder()
      .optionallyWith(
        deregisteredMulticastGroupSources.map(value => value.buildAwsValue())
      )(_.deregisteredMulticastGroupSources)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly =
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayMulticastGroupSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse =
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse(
        deregisteredMulticastGroupSources.map(value => value.asEditable)
      )
    def deregisteredMulticastGroupSources: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly
    ]
    def getDeregisteredMulticastGroupSources: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deregisteredMulticastGroupSources",
      deregisteredMulticastGroupSources
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse
  ) extends zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly {
    override val deregisteredMulticastGroupSources: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources.ReadOnly
    ] = scala
      .Option(impl.deregisteredMulticastGroupSources())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupSources
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse
  ): zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly =
    new Wrapper(impl)
}
