package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TaggableResourceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTagsRequest(
    resources: Iterable[TaggableResourceId],
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTagsRequest = {
    import DeleteTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTagsRequest
      .builder()
      .resources(resources.map { item =>
        TaggableResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTagsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTagsRequest.wrap(buildAwsValue())
}
object DeleteTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTagsRequest =
      zio.aws.ec2.model.DeleteTagsRequest(
        resources,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resources: List[TaggableResourceId]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getResources: ZIO[Any, Nothing, List[TaggableResourceId]] =
      ZIO.succeed(resources)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTagsRequest
  ) extends zio.aws.ec2.model.DeleteTagsRequest.ReadOnly {
    override val resources: List[TaggableResourceId] = impl
      .resources()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.TaggableResourceId(item)
      }
      .toList
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTagsRequest
  ): zio.aws.ec2.model.DeleteTagsRequest.ReadOnly = new Wrapper(impl)
}
