package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchTemplateVersionsResponseSuccessItem(
    launchTemplateId: Option[String] = None,
    launchTemplateName: Option[String] = None,
    versionNumber: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem = {
    import DeleteLaunchTemplateVersionsResponseSuccessItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
      .builder()
      .optionallyWith(launchTemplateId.map(value => value: java.lang.String))(
        _.launchTemplateId
      )
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .optionallyWith(versionNumber.map(value => value: java.lang.Long))(
        _.versionNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly =
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
      .wrap(buildAwsValue())
}
object DeleteLaunchTemplateVersionsResponseSuccessItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem =
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versionNumber.map(value => value)
      )
    def launchTemplateId: Option[String]
    def launchTemplateName: Option[String]
    def versionNumber: Option[Long]
    def getLaunchTemplateId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("versionNumber", versionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
  ) extends zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly {
    override val launchTemplateId: Option[String] =
      scala.Option(impl.launchTemplateId()).map(value => value: String)
    override val launchTemplateName: Option[String] =
      scala.Option(impl.launchTemplateName()).map(value => value: String)
    override val versionNumber: Option[Long] =
      scala.Option(impl.versionNumber()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem
  ): zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem.ReadOnly =
    new Wrapper(impl)
}
