package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorFilterResponse(
    trafficMirrorFilter: Option[zio.aws.ec2.model.TrafficMirrorFilter] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse = {
    import CreateTrafficMirrorFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
      .builder()
      .optionallyWith(trafficMirrorFilter.map(value => value.buildAwsValue()))(
        _.trafficMirrorFilter
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.wrap(buildAwsValue())
}
object CreateTrafficMirrorFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorFilterResponse =
      zio.aws.ec2.model.CreateTrafficMirrorFilterResponse(
        trafficMirrorFilter.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorFilter
        : Option[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]
    def clientToken: Option[String]
    def getTrafficMirrorFilter
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorFilter", trafficMirrorFilter)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly {
    override val trafficMirrorFilter
        : Option[zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] = scala
      .Option(impl.trafficMirrorFilter())
      .map(value => zio.aws.ec2.model.TrafficMirrorFilter.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorFilterResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly = new Wrapper(
    impl
  )
}
